/*------------------------------------------------------------------------------*
 * File Name:	Image.c		 													*
 * Creation: 	Danice															*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:		 													*
 *------------------------------------------------------------------------------*/
  
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>

#include <..\originlab\DialogEx.h>
#include <..\originlab\SplitterControl.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include "ViewMatrixImageSplitterDlg.h"
////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

typedef bool (*IMAGE_IMPORT_FUNC)(MatrixLayer& mlTarget, LPCSTR lpcszFile, TreeNode& trFileInfo = NULL);

static void import_images(vector<string>& vsFiles)
{
	IMAGE_IMPORT_FUNC pfun;
	for(int nOverloadIndex = 0; nOverloadIndex < 5; nOverloadIndex++)
	{
		pfun = Project.FindFunction("image_import_to_matrix", "Originlab\\image_utils.c", true, false, false, nOverloadIndex); 
		if( pfun )
			break;			
	}
	if( !pfun )
		return;
	
	for(int nFile = 0; nFile < vsFiles.GetSize(); nFile++)
	{
		MatrixPage mp;
		mp.Create("origin");
		
		MatrixLayer ml = Project.ActiveLayer();
		
		string strFile = vsFiles[nFile];		
		bool bRet = pfun(ml, strFile);
	}
}

void ViewMatrixImage()
{
	string strImagePath = GetAppPath(TRUE) + "Samples\\Image Processing and Analysis\\";
	
	vector<string> vsFiles(2);
	vsFiles[0] = strImagePath + "Car.bmp";
	vsFiles[1] = strImagePath + "Leaves.JPG";
	import_images(vsFiles);
	
	ViewMatrixImageSplitterDlg myDlg;
	myDlg.DoModal(GetWindow());
}

//////////////////////////////////////////////////////////////
//////////////////	ViewImageSplitterdlg /////////////////////
//////////////////////////////////////////////////////////////
ViewMatrixImageSplitterDlg::ViewMatrixImageSplitterDlg() : ResizeDialog(IDD_MYDIALOG, "ViewImageExample.dll")
{
}
ViewMatrixImageSplitterDlg::~ViewMatrixImageSplitterDlg()
{
}

BOOL ViewMatrixImageSplitterDlg::OnInitDialog()
{
	waitCursor junk;
	ResizeDialog::OnInitDialog(IDD_MYDIALOG, STR_DLG_NAME);

	m_splitter.Init(IDC_PICTURE_BOX, *this);
	m_btnOK = GetItem(IDOK);
	m_btnCancel = GetItem(IDCANCEL);

	m_splitter.OnReady();
	m_splitter.SetColSize(0, 40);
	return true;
}

BOOL ViewMatrixImageSplitterDlg::OnReady()
{
	m_splitter.OnReady();
	
	return true;
}

BOOL ViewMatrixImageSplitterDlg::OnDestroy()
{
	return ResizeDialog::OnDestroy();
}
BOOL ViewMatrixImageSplitterDlg::OnDlgResize(int nType, int cx, int cy)
{
	if((cx - cy) /2 == 0)
		return false;

	RECT r1, r2, r3;

	//Replace the "OK" button
	m_btnOK.GetWindowRect( &r1 );
	int nButtonWidth = r1.right - r1.left;
	int nButtonHeight = r1.bottom - r1.top;
	int nCloseButtonGap = nButtonHeight + 3; // Extra 3 pixel from bottom of dialog
	r1.left = cx/2 - nButtonWidth/2 - 60;
	r1.right = cx/2 + nButtonWidth/2 - 60;
	r1.top = cy - nCloseButtonGap;
	r1.bottom = r1.top + nButtonHeight;
	m_btnOK.MoveWindow( &r1 );	

	//Replace the "Cancel" button
	m_btnCancel.GetWindowRect( &r2 );
	nButtonWidth = r2.right - r2.left;
	nButtonHeight = r2.bottom - r2.top;
	nCloseButtonGap = nButtonHeight + 3;
	r2.left = cx/2 - nButtonWidth/2 + 60;
	r2.right = cx/2 + nButtonWidth/2 + 60;
	r2.top = cy - nCloseButtonGap;
	r2.bottom = r2.top + nButtonHeight;
	m_btnCancel.MoveWindow( &r2);


	// Re-size GraphControls
	// Place GraphControls side by side and leave some space for Close button
	int nBottom = cy - nCloseButtonGap -4;
	r3.left = 0, r3.top = 0, r3.right = cx, r3.bottom = nBottom;
	m_splitter.MoveWindow( &r3 );

	return true;
}

BOOL ViewMatrixImageSplitterDlg::OnClickOK()
{
	return true;
}

BOOL ViewMatrixImageSplitterDlg::OnClickCancel()
{
	return true;
}



//////////////////////////////////////////////////////////////
///////////////////		MatrixImageSplitter	//////////////////////
//////////////////////////////////////////////////////////////
MatrixImageSplitter::MatrixImageSplitter()
{

}
MatrixImageSplitter::~MatrixImageSplitter()
{
}
BOOL MatrixImageSplitter::OnInitSplitter()
{
	//set the tree view side
	GUID clsid; // later, for now, only vsFlex
	CreateActiveXPane(clsid, PANE_ROW_COL_LIST);		
	m_grid.Init(m_IDTreePane, *this);
	m_grid.ShowGraphList();

	//set the preview side
	CreatePane(m_picCtrl, PANE_ROW_COL_PAGE);
	updatePreview( m_grid.GetSelectedMatrix() );

	SetReady();

	return true;
}
BOOL MatrixImageSplitter::OnDestroy()
{
	return true;
}
BOOL MatrixImageSplitter::OnResize(int nType, int cx, int cy)
{
	SplitterControl::OnResize(nType, cx, cy);
	return true;
}

BOOL MatrixImageSplitter::OnRowChange(Control ctrl)
{
	updatePreview( m_grid.GetSelectedMatrix() );

	OnReady();
	return true;
}


bool MatrixImageSplitter::updatePreview(const MatrixLayer& ml)
{
	if(ml)
	{
		MatrixObject mo = ml.MatrixObjects();
		LPVOID pLBitmap = mo.GetLeadBitmap();
		if(NULL != pLBitmap && m_picCtrl)
		{
			m_picCtrl.Visible = false;
			bool bRet = m_picCtrl.SetLeadBitmap(pLBitmap, false);
			m_picCtrl.Visible = true;
			return bRet;
		}				
	}
	return false;
}

bool MatrixImageSplitter::updatePreview(LPCSTR lpcszMatrix)
{
	string strMatrix(lpcszMatrix);
	if(strMatrix.IsEmpty())
		return false;	
	
	MatrixPage mp(strMatrix);
	if(mp)
	{
		MatrixLayer ml = mp.Layers(); // active layer
		return updatePreview(ml);
	}
	
	return false;
}
